﻿# Taken from http://stackoverflow.com/questions/495618/how-to-normalize-a-path-in-powershell
function Get-AbsolutePath($Path)
{
    # System.IO.Path.Combine has two properties making it necesarry here:
    #   1) correctly deals with situations where $Path (the second term) is an absolute path
    #   2) correctly deals with situations where $Path (the second term) is relative
    # (join-path) commandlet does not have this first property
    $Path = [System.IO.Path]::Combine( ((pwd).Path), ($Path) );

    # this piece strips out any relative path modifiers like '..' and '.'
    $Path = [System.IO.Path]::GetFullPath($Path);

    return $Path;
}

# Find the location of Signtool.
$regEntry = Get-ItemProperty -Path "Registry::HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SDKs\Windows\v7.1A"
$value = $regEntry.'InstallationFolder'
$file = $value + "Bin\signtool.exe"
$signTool = Get-ChildItem $file

# Get the password for the certificate.
$password = Get-Content ..\..\DontDeploy\certpw.txt
$parms = 'sign', '/f', "$(Get-AbsolutePath('..\..\DontDeploy\mycert.pfx'))", '/p', $password

# Sign the exe.
$signParms = $parms + '/d', 'My Application', '..\myapp.exe'
& $signTool $signParms

# Find the location of the Inno Setup compiler.
$regEntry = Get-ItemProperty -Path Registry::HKEY_CLASSES_ROOT\InnoSetupScriptFile\Shell\Compile\Command
$value = $regEntry.'(default)'
$file = $value.Substring(1, $value.IndexOf('"', 2) - 1)
$exe = Get-ChildItem $file
$innoCompiler = $exe.DirectoryName + "\iscc"

# Build WSSetup.exe and Setup.exe
$signParms = "/sStandard=$signTool $parms $" + "p"
& $innoCompiler $signParms WSSetup.iss | Out-Null
& $innoCompiler $signParms MyAppSignedWithWS.iss
